% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_perim.R
\name{lsm_p_perim}
\alias{lsm_p_perim}
\title{PERIM (patch level)}
\usage{
lsm_p_perim(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Perimeter (Area and edge metric)
}
\details{
\deqn{PERIM = p_{ij}}
where \eqn{p_{ij}} is the perimeter in meters.

PERIM is an 'Area and edge metric'. It equals the perimeter of the patch
including also the edge to the landscape boundary. The metric describes
patch area (larger perimeter for larger patches), but also patch shape
(large perimeter for irregular shapes).

\subsection{Units}{Meters}
\subsection{Range}{PERIM > 0}
\subsection{Behaviour}{Increases, without limit, as patch size and
complexity increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_p_perim(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
