% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_ed.R
\name{lsm_l_ed}
\alias{lsm_l_ed}
\alias{lsm_l_ed.RasterLayer}
\alias{lsm_l_ed.RasterStack}
\alias{lsm_l_ed.RasterBrick}
\alias{lsm_l_ed.stars}
\alias{lsm_l_ed.list}
\title{ED (landscape level)}
\usage{
lsm_l_ed(landscape, count_boundary, directions)

\method{lsm_l_ed}{RasterLayer}(landscape, count_boundary = FALSE,
  directions = 8)

\method{lsm_l_ed}{RasterStack}(landscape, count_boundary = FALSE,
  directions = 8)

\method{lsm_l_ed}{RasterBrick}(landscape, count_boundary = FALSE,
  directions = 8)

\method{lsm_l_ed}{stars}(landscape, count_boundary = FALSE,
  directions = 8)

\method{lsm_l_ed}{list}(landscape, count_boundary = FALSE,
  directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{count_boundary}{Count landscape boundary as edge}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Edge Density (Area and Edge metric)
}
\details{
\deqn{ED = \frac{E} {A} * 10000}
where \eqn{E} is the total landscape edge in meters and \eqn{A} is the total
landcape area in square meters.

ED is an 'Area and Edge metric'. The edge density equals all edges in the landscape
in relation to the landcape area. The boundary of the landscape is only included in the
corresponding total class edge length if \code{count_boundary = TRUE}.
The metric describes the configuration of the landscape, e.g. because an overall aggregation
of  classes will result in a low edge density. The metric is standardized to the
total landscape area, and therefore comparisons among landscapes with different total
areas are possible.
\subsection{Units}{Meters per hectare}
\subsection{Range}{ED >= 0}
\subsection{Behaviour}{Equals ED = 0 if only one patch is present (and the landscape
boundary is not included) and increases, without limit, as the landscapes becomes more
patchy}
}
\examples{
lsm_l_ed(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_l_te}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_c_ed}}
}
