% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePatch.R
\name{makePatch}
\alias{makePatch}
\title{Create a single patch}
\usage{
makePatch(context, size, spt = NULL, bgr = 0, edge = FALSE,
  rast = FALSE, val = 1)
}
\arguments{
\item{context}{Raster object or matrix, an empty landscape raster or a mask indicating where the patch cannot be generated (see bgr below).}

\item{size}{integer. Size of the patch to be generated, as number of raster cells.}

\item{spt}{integer or matrix. The seed point location around which the patch is generated (a random point is given by default). It can be an integer, as index of the cell in the raster, or a two columns matrix indicating x and y coordinates (an integer vector of length 2 is accepted too).}

\item{bgr}{integer. A single value of background cells, where a patch can be generated (default is zero). Cells/classes which cannot be changed must have a different value.}

\item{edge}{logical. Should the vector of edge cells of the patch be returned?}

\item{rast}{logical. If TRUE returns a Raster object, otherwise a vector of cell numbers where the patch occurs}

\item{val}{integer. The value to be assigned to patch cells, when \code{rast=TRUE}}
}
\value{
A vector of raster cell numbers, or a RasterLayer object if \code{rast=TRUE}. If \code{edge=TRUE} a
list of two vectors is returned: one for the inner raster cells and the second for cells at the edge of the patch.
}
\description{
Function will create a single patch. \strong{NOTE}: \code{makeClass} should be used preferably when creating a single patch, as better error and exception handling is provided.
}
\details{
The patch is created starting from the seed point and iteratively sampling randomly neighbouring cells at the edge of the patch, according to von Neumann neighbourhood (four cells, aka Rook case).
There is a tolerance of +/- 3 cells from the patch size declared in \code{size} argument.
Argument \code{bgr} accepts a single value only, unlike \code{makeClass} that accepts multiple and should therefore preferred.
}
\examples{
library(raster)
mtx = matrix(0, 33, 33)
r = raster(mtx, xmn=0, xmx=10, ymn=0, ymx=10)
patchSize = 500
rr = makePatch(r, patchSize, rast=TRUE)
plot(rr)

## Create a patch with value 3, starting from the centre cell
mtx = matrix(0, 33, 33)
r = raster(mtx, xmn=0, xmx=10, ymn=0, ymx=10)
newVal = 3
centre = 545
cells = makePatch(r, patchSize, centre)
r[cells] = newVal
plot(r)

## Now create a new patch with value 10 and size 100 inside the existing patch
rr = makePatch(r, 100, bgr=newVal, rast=TRUE, val=10)
plot(rr)
}
