% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Instance.R
\name{Instance}
\alias{Instance}
\title{Instance}
\description{
Connect to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
The instance object provides access to the modules and registries
of the instance.
}
\details{
Note that by connecting to an instance via \code{\link[=connect]{connect()}}, you receive
a "richer" version of the Instance class documented here, providing
direct access to all core registries and additional modules.
See the vignette on "Package Architecture" for more information:
\code{vignette("architecture", package = "laminr")}.
}
\examples{
\dontrun{
# Connect to an instance
db <- connect("laminlabs/cellxgene")

# fetch an artifact
artifact <- db$Artifact$get("KBW89Mf7IGcekja2hADu")

# describe the artifact
artifact$describe()

# view field
artifact$id

# load dataset
artifact$load()
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{is_default}}{(\code{logical(1)})\cr
Whether this is the default instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Instance-new}{\code{Instance$new()}}
\item \href{#method-Instance-get_modules}{\code{Instance$get_modules()}}
\item \href{#method-Instance-get_module}{\code{Instance$get_module()}}
\item \href{#method-Instance-get_module_names}{\code{Instance$get_module_names()}}
\item \href{#method-Instance-get_settings}{\code{Instance$get_settings()}}
\item \href{#method-Instance-get_api}{\code{Instance$get_api()}}
\item \href{#method-Instance-get_py_lamin}{\code{Instance$get_py_lamin()}}
\item \href{#method-Instance-track}{\code{Instance$track()}}
\item \href{#method-Instance-finish}{\code{Instance$finish()}}
\item \href{#method-Instance-print}{\code{Instance$print()}}
\item \href{#method-Instance-to_string}{\code{Instance$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-new"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$new(settings, api, schema, is_default, py_lamin)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{settings}}{The settings for the instance}

\item{\code{api}}{The API for the instance}

\item{\code{schema}}{The schema for the instance}

\item{\code{is_default}}{Logical, whether this is the default instance}

\item{\code{py_lamin}}{A Python \code{lamindb} module object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_modules"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_modules}{}}}
\subsection{Method \code{get_modules()}}{
Get the modules for the instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_modules()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \link{Module} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_module"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_module}{}}}
\subsection{Method \code{get_module()}}{
Get a module by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_module(module_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module_name}}{The name of the module.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \link{Module} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_module_names"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_module_names}{}}}
\subsection{Method \code{get_module_names()}}{
Get the names of the modules. Example: \code{c("core", "bionty")}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_module_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of module names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_settings"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_settings}{}}}
\subsection{Method \code{get_settings()}}{
Get instance settings.

Note: This method is intended for internal use only and may be removed in the future.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_settings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The settings for the instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_api"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_api}{}}}
\subsection{Method \code{get_api()}}{
Get instance API.

Note: This method is intended for internal use only and may be removed in the future.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_api()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The API for the instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-get_py_lamin"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-get_py_lamin}{}}}
\subsection{Method \code{get_py_lamin()}}{
Get the Python lamindb module
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$get_py_lamin(check = FALSE, what = "This functionality")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{check}}{Logical, whether to perform checks}

\item{\code{what}}{What the python module is being requested for, used in check
messages}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Python lamindb module.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-track"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-track}{}}}
\subsection{Method \code{track()}}{
Start a run with tracked data lineage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$track(transform = NULL, path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transform}}{UID specifying the data transformation}

\item{\code{path}}{Path to the R script or document to track}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Calling \code{track()} with \code{transform = NULL} with return a UID, providing
that UID with the same path with start a run
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-finish"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-finish}{}}}
\subsection{Method \code{finish()}}{
Finish a tracked run
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$finish()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-print"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-print}{}}}
\subsection{Method \code{print()}}{
Print an \code{Instance}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Instance-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Instance-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of an \code{Instance}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
