% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start-lambda.R
\name{start_lambda}
\alias{start_lambda}
\title{Start the Lambda runtime}
\usage{
start_lambda(
  config = lambda_config(environ = parent.frame()),
  timeout_seconds = NULL
)
}
\arguments{
\item{config}{A list of configuration values as created by the
\code{lambda_config} function.}

\item{timeout_seconds}{If set, the function will stop listening for events
after this timeout. The timeout is checked between events, so this won't
interrupt the function while it is waiting for a new event. This argument
is provided for testing purposes, and shouldn't otherwise need to be set:
AWS should handle the shutdown of idle Lambda instances.}
}
\description{
This is the main function of the package, responsible for starting the
infinite loop of listening for new invocations. It relies on configuration
provided to the \code{config} argument and produced by the
\code{\link{lambda_config}} function.
}
\details{
See \code{vignette("lambda-runtime-in-container", package = "lambdr")} for an
example of how to use this function to place an R Lambda Runtime in a
container.

This package uses the \code{\link[logger]{logger}} package for logging.
Debug log entries can be enabled with \code{logger::log_threshold(logger::DEBUG)}.
This will log additional information such as raw event bodies.
}
\section{Event context}{

Context is metadata associated with each invocation. If the handler function
accepts a \code{context} argument then it will automatically receive at runtime a
named list consisting of these values along with the arguments in the body
(if any). For example, a function such as \code{my_func(x, context)} will receive
the context argument automatically. The \code{context} argument must be named
(\code{...} will not work).

Refer to \code{vignette("lambda-runtime-in-container", package = "lambdr")}
for details.
}

\section{AWS Lambda variables}{


The \code{\link{lambda_config}} function obtains the configuration values
for the Lambda runtime configures the R session for Lambda based on
environment variables made available by Lambda. The following environment
variables are available:
\itemize{
\item Lambda Runtime API, available as the "AWS_LAMBDA_RUNTIME_API" environment
variable, is the host of the various HTTP endpoints through which the
runtime interacts with Lambda.
\item Lambda Task Root, available as the "LAMBDA_TASK_ROOT" environment variable,
defines the path to the Lambda function code. It isn't used in container
environments with a custom runtime, as that runtime is responsible for
finding and sourcing the function code. Hence, a missing task root is
ignored by this package.
\item The handler, available as the "_HANDLER" environment variable, is
interpreted by R as the function that is executed when the Lambda is
called. This value could be anything, as the interpretation is solely up
to the runtime, so requiring it to be a function is a standard imposed by
this package.
}

These \code{handler}, \code{runtime_api} and \code{task_root} arguments to the
\code{\link{lambda_config}} function can also provide values to these
configuration options, although the environment variables will always be
used if available. While it may be sensible to provide the \code{handler}
function directly, the other two configuration options are only provided for
debugging and testing purposes.
}

\examples{
\dontrun{
# A general usage pattern involves sourcing necessary functions and running
# this `start_lambda` in a `runtime.R` file which is then executed to start
# the runtime. In the following example, the function handler can be set to
# "lambda" either as the container `CMD`, or configured through AWS Lambda.

parity <- function(number) {
  list(parity = if (as.integer(number) \%\% 2 == 0) "even" else "odd")
}

start_lambda()

# Alternatively, it can be passed as an argument `handler = parity` to
# the lambda configuration. If the handler is configured through other means
# then this will be ignored:

start_lambda(config = lambda_config(handler = parity))
}
}
