% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled.R
\name{labelled}
\alias{is.labelled}
\alias{labelled}
\title{Create a labelled vector.}
\usage{
labelled(x, labels)

is.labelled(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector. The vector should be the same type as
\code{x}. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}
}
\description{
A labelled vector is a common data structure in other statistical environments,
allowing you to assign text labels to specific values.
}
\examples{
s1 <- labelled(c('M', 'M', 'F'), c(Male = 'M', Female = 'F'))
s1
s2 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2))
s2
is.labelled(s1)
}
\seealso{
\code{\link[haven]{labelled}} (\pkg{haven})

\code{\link[haven]{is.labelled}} (\pkg{haven})
}

