% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_correct.R
\docType{methods}
\name{correct.tag}
\alias{correct.tag}
\alias{correct.tag,kRp.taggedText-method}
\title{Methods to correct koRpus objects}
\usage{
correct.tag(obj, row, tag = NULL, lemma = NULL, check.token = NULL)

\S4method{correct.tag}{kRp.taggedText}(obj, row, tag = NULL,
  lemma = NULL, check.token = NULL)
}
\arguments{
\item{obj}{An object of class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}},
      \code{\link[koRpus:kRp.txt.freq-class]{kRp.txt.freq}},
\code{\link[koRpus:kRp.analysis-class]{kRp.analysis}},
      or \code{\link[koRpus:kRp.txt.trans-class]{kRp.txt.trans}}.}

\item{row}{Integer, the row number of the entry to be changed. Can be an integer vector
to change several rows in one go.}

\item{tag}{A character string with a valid POS tag to replace the current tag entry.
If \code{NULL} (the default) the entry remains unchanged.}

\item{lemma}{A character string naming the lemma to to replace the current lemma entry.
If \code{NULL} (the default) the entry remains unchanged.}

\item{check.token}{A character string naming the token you expect to be in this row.
If not \code{NULL}, \code{correct} will stop with an error if this values don't match.}
}
\value{
An object of the same class as \code{obj}.
}
\description{
The method \code{correct.tag} can be used to alter objects of class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}}.
}
\details{
Although automatic POS tagging and lemmatization are remarkably accurate,
      the algorithms do ususally produce
some errors. If you want to correct for these flaws, this method can be of help,
      because it might prevent you from
introducing new errors. That is,
      it will do some sanitiy checks before the object is actually manipulated and returned.

\code{correct.tag} will read the \code{lang} slot from the given object and check whether the \code{tag}
provided is actually valid. If so,
      it will not only change the \code{tag} field in the object, but also update
\code{wclass} and \code{desc} accordingly.

If \code{check.token} is set it must also match \code{token} in the given row(s). Note that no check is done on the lemmata.
}
\examples{
\dontrun{
tagged.txt <- correct.tag(tagged.txt, row=21, tag="NN")
}
}
\seealso{
\code{\link[koRpus:kRp.tagged-class]{kRp.tagged}}, \code{\link[koRpus:treetag]{treetag}},
   \code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}}.
}
\keyword{methods}
