% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clust4}
\alias{clust4}
\title{4-clustered data set}
\format{A data frame with 300 rows and 3 variables:
\describe{
  \item{x1}{X1.}
  \item{x2}{X2.}
  \item{class}{Class membership.}
}}
\source{
Data is generated via the \code{genRandomClust} function in the
\pkg{clusterGeneration} package. The code to generate this data
set is

set.seed(2016)

randclust <- clusterGeneration::genRandomClust(4, sepVal = 0.001,
numNonNoisy = 2, numReplicate = 1, clustszind = 3,
clustSizes = as.numeric(table(sample(1:4, 300, replace = TRUE))),
outputDatFlag=FALSE, outputLogFlag=FALSE, outputEmpirical=FALSE,
outputInfo=FALSE)

clust4 <- as.data.frame(randclust$datList$test_1)

clust4$class <- randclust$memList$test_1
}
\usage{
clust4
}
\description{
A dataset containing two variables of 300 objects and their class memberships
generated by the \pkg{clusterGeneration} package.
}
\references{
Qiu, W., and H. Joe. 2015. ClusterGeneration: Random Cluster
Generation (with Specified Degree of Separation).

Qiu, W., and H. Joe. 2006a. Generation of Random Clusters with
Specified Degree of Separation. Journal of Classification 23 pp. 315-34.

Qiu, W., and H. Joe. 2006b. Separation Index and Partial
Membership for Clustering. Computational Statistics and Data Analysis 50
pp. 585-603.
}
\keyword{datasets}
