% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata_helpers.R
\name{metadata-helpers}
\alias{metadata-helpers}
\alias{get_categories}
\alias{get_category_combos}
\alias{get_category_option_combos}
\alias{get_category_option_group_sets}
\alias{get_category_option_groups}
\alias{get_category_options}
\alias{get_data_element_group_sets}
\alias{get_data_element_groups}
\alias{get_data_elements}
\alias{get_data_sets}
\alias{get_user_groups}
\alias{get_indicator_group_sets}
\alias{get_indicator_groups}
\alias{get_indicators}
\alias{get_option_group_sets}
\alias{get_option_groups}
\alias{get_option_sets}
\alias{get_options}
\alias{get_organisation_unit_groupsets}
\alias{get_organisation_unit_groups}
\alias{get_organisation_units}
\alias{get_organisation_unit_levels}
\alias{get_dimensions}
\alias{get_period_types}
\title{DHIS2 Metadata Helper Functions}
\usage{
get_categories(...)

get_category_combos(...)

get_category_option_combos(...)

get_category_option_group_sets(...)

get_category_option_groups(...)

get_category_options(...)

get_data_element_group_sets(...)

get_data_element_groups(...)

get_data_elements(...)

get_data_sets(...)

get_user_groups(...)

get_indicator_group_sets(...)

get_indicator_groups(...)

get_indicators(...)

get_option_group_sets(...)

get_option_groups(...)

get_option_sets(...)

get_options(...)

get_organisation_unit_groupsets(...)

get_organisation_unit_groups(...)

get_organisation_units(...)

get_organisation_unit_levels(...)

get_dimensions(...)

get_period_types(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=get_metadata]{get_metadata}}
  \describe{
    \item{\code{fields}}{The specific columns to be returned in the data frame.}
    \item{\code{retry}}{Number of times to retry the API call in case of failure
(defaults to 2).}
    \item{\code{verbosity}}{Level of HTTP information to print during the call:
\itemize{
\item 0: No output
\item 1: Show headers
\item 2: Show headers and bodies
\item 3: Show headers, bodies, and CURL status message.
}}
    \item{\code{timeout}}{Maximum number of seconds to wait for the DHIS2 API response.}
  }}
}
\value{
A tibble containing the DHIS2 metadata response.
}
\description{
These functions simplify retrieving data from specific DHIS2 API endpoints
using \code{\link[=get_metadata]{get_metadata()}}.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Get all organisation units
get_organisation_units()

# Get all data elements
get_data_elements()

# Get data elements by element ids
get_data_elements(id \%.in\% c('VR7vdS7P0Gb', 'gQro1y7Rsbq'))

# Get datasets by name with the word 'MOH 705'
get_data_sets(name \%.like\% 'MOH 705')
\dontshow{\}) # examplesIf}
}
