% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-aliases.R
\name{new_callback_class}
\alias{new_callback_class}
\title{Callback}
\usage{
new_callback_class(
  classname,
  on_epoch_begin = NULL,
  on_epoch_end = NULL,
  on_train_begin = NULL,
  on_train_end = NULL,
  on_train_batch_begin = NULL,
  on_train_batch_end = NULL,
  on_test_begin = NULL,
  on_test_end = NULL,
  on_test_batch_begin = NULL,
  on_test_batch_end = NULL,
  on_predict_begin = NULL,
  on_predict_end = NULL,
  on_predict_batch_begin = NULL,
  on_predict_batch_end = NULL,
  ...,
  public = list(),
  private = list(),
  inherit = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{classname}{String, the name of the custom class. (Conventionally, CamelCase).}

\item{on_epoch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(epoch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the start of an epoch.

Subclasses should override for any actions to run. This function should
only be called during TRAIN mode.

Args:
\itemize{
\item \code{epoch}: Integer, index of epoch.
\item \code{logs}: Named List. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_epoch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(epoch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of an epoch.

Subclasses should override for any actions to run. This function should
only be called during TRAIN mode.

Args:
\itemize{
\item \code{epoch}: Integer, index of epoch.
\item \code{logs}: Named List, metric results for this training epoch, and for the
validation epoch if validation is performed. Validation result
keys are prefixed with \code{val_}. For training epoch, the values of
the \code{Model}'s metrics are returned. Example:
\code{list(loss = 0.2, accuracy = 0.7)}.
}}

\item{on_train_begin}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of training.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_train_end}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of training.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently the output of the last call to
\code{on_epoch_end()} is passed to this argument for this method but
that may change in the future.
}}

\item{on_train_batch_begin}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a training batch in \code{fit()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_train_batch_end}{\if{html}{\out{<div class="sourceCode">}}\preformatted{\\(batch, logs=NULL)
}\if{html}{\out{</div>}}

Called at the end of a training batch in \code{fit()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{on_test_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of evaluation or validation.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_test_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of evaluation or validation.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently the output of the last call to
\code{on_test_batch_end()} is passed to this argument for this method
but that may change in the future.
}}

\item{on_test_batch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a batch in \code{evaluate()} methods.

Also called at the beginning of a validation batch in the \code{fit()}
methods, if validation data is provided.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_test_batch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of a batch in \code{evaluate()} methods.

Also called at the end of a validation batch in the \code{fit()}
methods, if validation data is provided.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{on_predict_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of prediction.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of prediction.

Subclasses should override for any actions to run.

Args:
\itemize{
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_batch_begin}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the beginning of a batch in \code{predict()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile()} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Currently no data is passed to this argument for this
method but that may change in the future.
}}

\item{on_predict_batch_end}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{\\(batch, logs = NULL)
}\if{html}{\out{</div>}}

Called at the end of a batch in \code{predict()} methods.

Subclasses should override for any actions to run.

Note that if the \code{steps_per_execution} argument to \code{compile} in
\code{Model} is set to \code{N}, this method will only be called every
\code{N} batches.

Args:
\itemize{
\item \code{batch}: Integer, index of batch within the current epoch.
\item \code{logs}: Named list. Aggregated metric results up until this batch.
}}

\item{..., public}{Additional methods or public members of the custom class.}

\item{private}{Named list of R objects (typically, functions) to include in
instance private environments. \code{private} methods will have all the same
symbols in scope as public methods (See section "Symbols in Scope"). Each
instance will have it's own \code{private} environment. Any objects
in \code{private} will be invisible from the Keras framework and the Python
runtime.}

\item{inherit}{What the custom class will subclass. By default, the base keras class.}

\item{parent_env}{The R environment that all class methods will have as a grandparent.}
}
\value{
A function that returns the custom \code{Callback} instances,
similar to the builtin callback functions.
}
\description{
\code{new_callback_class()} is an alias for \code{\link[=Callback]{Callback()}}.
See \verb{?}\code{\link[=Callback]{Callback()}} for the full documentation.
}
\keyword{internal}
