% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-noise.R
\name{layer_gaussian_dropout}
\alias{layer_gaussian_dropout}
\title{Apply multiplicative 1-centered Gaussian noise.}
\usage{
layer_gaussian_dropout(object, rate, seed = NULL, ...)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{rate}{float, drop probability (as with \code{Dropout}). The multiplicative
noise will have standard deviation \code{sqrt(rate / (1 - rate))}.}

\item{seed}{Integer, optional random seed to enable deterministic behavior.}

\item{...}{standard layer arguments.}
}
\description{
As it is a regularization layer, it is only active at training time.
}
\section{Input shape}{
 Arbitrary. Use the keyword argument \code{input_shape} (list
of integers, does not include the samples axis) when using this layer as
the first layer in a model.
}

\section{Output shape}{
 Same shape as input.
}

\section{References}{

\itemize{
\item \href{https://www.cs.toronto.edu/~rsalakhu/papers/srivastava14a.pdf}{Dropout: A Simple Way to Prevent Neural Networks from Overfitting Srivastava, Hinton, et al. 2014}
}
}

\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/GaussianDropout}
}

Other noise layers: 
\code{\link{layer_alpha_dropout}()},
\code{\link{layer_gaussian_noise}()}
}
\concept{noise layers}
