% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde1d.R
\name{dkde1d}
\alias{dkde1d}
\alias{pkde1d}
\alias{pkde1d,}
\alias{qkde1d}
\alias{qkde1d,}
\alias{rkde1d}
\title{Working with a kde1d object}
\usage{
dkde1d(x, obj)

pkde1d(x, obj)

qkde1d(x, obj)

rkde1d(n, obj, quasi = FALSE)
}
\arguments{
\item{x}{vector of evaluation points.}

\item{obj}{a \code{kde1d} object.}

\item{n}{integer; number of observations.}

\item{quasi}{logical; the default (\code{FALSE}) returns pseudo-random
numbers, use \code{TRUE} for quasi-random numbers (generalized Halton, see
\code{\link[qrng:ghalton]{ghalton}}).}
}
\value{
The density or cdf estimate evaluated at \code{x}.
}
\description{
The density, cdf, or quantile function of a kernel density estimate are
evaluated at arbitrary points with \code{\link{dkde1d}}, \code{\link{pkde1d}},
and \code{\link{qkde1d}} respectively.
}
\examples{
data(wdbc)  # load data
fit <- kde1d(wdbc[, 5])  # estimate density
dkde1d(1000, fit)  # evaluate density estimate
pkde1d(1000, fit)  # evaluate corresponding cdf

}
\seealso{
\code{\link{kde1d}}
}

