# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Evaluate the mirror reflection estimator
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param b bandwidth parameter.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_mr <- function(uev, dat, b) {
    .Call('kdecopula_eval_mr', PACKAGE = 'kdecopula', uev, dat, b)
}

#' Evaluate the beta kernel estimator
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param b bandwidth parameter.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_beta <- function(uev, dat, b) {
    .Call('kdecopula_eval_beta', PACKAGE = 'kdecopula', uev, dat, b)
}

#' Evaluate the transformation estimator 
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param B 2x2 bandwidth matrix; must be positive definite.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_t <- function(uev, dat, B) {
    .Call('kdecopula_eval_t', PACKAGE = 'kdecopula', uev, dat, B)
}

#' Evaluate an h-function corresponding to a copula density estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param cond_var either 1 or 2; the variable to condition on.
#' @param vals matrix of density estimate evaluated on a kxk grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' 
#' @return H-function estimate evaluated at uev.
#' 
#' @noRd
eval_hfunc_2d <- function(uev, cond_var, vals, grid) {
    .Call('kdecopula_eval_hfunc_2d', PACKAGE = 'kdecopula', uev, cond_var, vals, grid)
}

#' Evaluate the inverse of an h-function corresponding to a copula density 
#' estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param cond_var either 1 or 2; the variable to condition on.
#' @param vals matrix of density estimate evaluated on a kxk grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' 
#' @return Inverse h-function estimate evaluated at uev.
#' 
#' @noRd
inv_hfunc <- function(uev, cond_var, vals, grid) {
    .Call('kdecopula_inv_hfunc', PACKAGE = 'kdecopula', uev, cond_var, vals, grid)
}

#' Evaluate the cdf corresponding to a copula density estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param vals vector of density estimate evaluated on a grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' @param helpgrid auxiliary grid; see body of pkdecop.
#' @param helpind auxiliary indicators; see body of pkdecop.
#' 
#' @return Copula cdf estimate evaluated at uev.
#' 
#' @noRd
eval_cdf <- function(uev, vals, grid, helpgrid, helpind) {
    .Call('kdecopula_eval_cdf', PACKAGE = 'kdecopula', uev, vals, grid, helpgrid, helpind)
}

#' Integrate a spline interpolant
#' 
#' @param upr upper limit of integration (lower is 0).
#' @param vals vector of values to be interpolated and integrated.
#' @param grid vector of grid points on which vals has been computed.
#' 
#' @return Integral of interpolation spline defined by (vals, grid).
#' 
#' @noRd
int_on_grid <- function(upr, vals, grid) {
    .Call('kdecopula_int_on_grid', PACKAGE = 'kdecopula', upr, vals, grid)
}

#' Inverse of the integral of a spline interpolant
#' 
#' @param qq argument of the inverse integral (the 'quantile').
#' @param vals vector of values to be interpolated and integrated.
#' @param grid vector of grid points on which vals has been computed.
#' 
#' @return Integral of interpolation spline defined by (vals, grid).
#' 
#' @noRd
inv_int_on_grid <- function(qq, vals, grid) {
    .Call('kdecopula_inv_int_on_grid', PACKAGE = 'kdecopula', qq, vals, grid)
}

#' Evaluate a cubic polynomial
#' 
#' @param x evaluation point.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

#' Indefinite integral of cubic polynomial
#' 
#' @param x evaluation point.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

#' Compute integral of cubic polynomial given upper and lower limits
#' 
#' @param lowr lower limit of the integral.
#' @param upr upper limit of the integral.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

#' Numerically invert a cubic integral (with 0 as lower bound)
#' 
#' @param q evaluation point (a 'quantile').
#' @param a vector of polynomial coefficients.
#' 
#' @details The inverse is found by the bisection method with a maximum of 20 
#' iterations.
#' 
#' @noRd
NULL

#' Calculate coefficients for cubic splines
#' 
#' @param vals length 4 vector of function values.
#' @param grid length 4 vector of grid points.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

#' Interpolate in one dimension
#' 
#' @param x evaluation point.
#' @param vals length 4 vector of function values.
#' @param grid length 4 vector of grid points.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

#' Subset a vector as if it were a multi-dimensional array
#' 
#' @param ind mxd matrix of indices
#' @param vector dimensions of the implicit array; a vector of length d.
#' 
#' @noRd
NULL

#' Interpolate in two dimensions
#' 
#' @param x mx2 matrix of evaluation points.
#' @param vals function values on a kxk grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
interp_2d <- function(x, vals, grid, tmpgrid, tmpvals) {
    .Call('kdecopula_interp_2d', PACKAGE = 'kdecopula', x, vals, grid, tmpgrid, tmpvals)
}

#' Interpolate on an array with more than two dimensions
#' 
#' @param x mxd matrix of evaluation points.
#' @param vals function values on a d-dimensional grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' @param helpind a matrix of auxiliary indices (see function pkdecop).
#' 
#' @noRd
interp <- function(x, vals, grid, helpind) {
    .Call('kdecopula_interp', PACKAGE = 'kdecopula', x, vals, grid, helpind)
}

#' Epanechnikov kernel (univariate)
#' 
#' @param x vector of evaluation points.
#' @param b bandwidth parameter.
#' 
#' @noRd
kern_epan_1d <- function(x, b) {
    .Call('kdecopula_kern_epan_1d', PACKAGE = 'kdecopula', x, b)
}

#' Epanechnikov product kernel (bivariate)
#' 
#' Computes \eqn{K(x/b, y/b) / b}.
#' 
#' @param x vector of evaluation points.
#' @param y vector of evaluation points.
#' @param b bandwidth parameter.
#' 
#' @noRd
kern_epan_2d <- function(x, y, b) {
    .Call('kdecopula_kern_epan_2d', PACKAGE = 'kdecopula', x, y, b)
}

#' Epanechnikov product kernel (arbitray dimension)
#' 
#' @param x mxd matrix of evaluation points.
#' @param b length d vector of bandwidth parameters.
#' 
#' @noRd
kern_epan <- function(x, b) {
    .Call('kdecopula_kern_epan', PACKAGE = 'kdecopula', x, b)
}

#' Gaussian kernel (univariate)
#' 
#' @param x vector of evaluation points.
#' @param b bandwidth parameter.
#' 
#' @noRd
kern_gauss_1d <- function(x, b) {
    .Call('kdecopula_kern_gauss_1d', PACKAGE = 'kdecopula', x, b)
}

#' Gaussian product kernel (bivariate)
#' 
#' Computes \eqn{K(x/b, y/b) / b}.
#' 
#' @param x vector of evaluation points.
#' @param y vector of evaluation points.
#' @param b bandwidth parameter.
#' 
#' @noRd
kern_gauss_2d <- function(x, y, b) {
    .Call('kdecopula_kern_gauss_2d', PACKAGE = 'kdecopula', x, y, b)
}

#' Gaussian product kernel (arbitray dimension)
#' 
#' @param x mxd matrix of evaluation points.
#' @param b length d vector of bandwidth parameters.
#' 
#' @noRd
kern_gauss <- function(x, b) {
    .Call('kdecopula_kern_gauss', PACKAGE = 'kdecopula', x, b)
}

#' Renormalize a subset of an array
#' 
#' The subset is given as a concatenated vector of d-1 sequences of length m 
#' (grid size). The renormalized sequence corresponds to a spline interpolant 
#' that integrates to one.
#' 
#' @param vals concatenated vector of function values.
#' @param grid vector of (univariate) grid points.
#' @param d dimension of the array.
#' 
#' @noRd
ren_subs <- function(vals, grid, d) {
    .Call('kdecopula_ren_subs', PACKAGE = 'kdecopula', vals, grid, d)
}

#' Renormalize a d-dimensional copula density
#' 
#' 
#' @param x concatenated vector of function values.
#' @param grid vector of (univariate) grid points.
#' @param times iterations of the renormalization procedure.
#' @param helpind the (d-1)-dimensional expanded sequence 0:(knots-1).
#' 
#' @noRd
renorm <- function(x, grid, times, helpind) {
    .Call('kdecopula_renorm', PACKAGE = 'kdecopula', x, grid, times, helpind)
}

