% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kcop.R
\name{kcop}
\alias{kcop}
\alias{pkcopula}
\alias{dkcopula}
\title{The Bivariate K-Copula}
\usage{
pkcopula(u, v, c, N, output = "vector", method = "interpolate")

dkcopula(u, v, c, N, output = "vector")
}
\arguments{
\item{u, v}{Numeric vectors with values in \eqn{[0, 1]}.}

\item{c}{Numeric; Pearson correlation coefficient in \eqn{[-1, 1]}.}

\item{N}{Numeric; inverse fluctuation strength of correlations around
their average \code{c}, \eqn{N>0}. The larger \code{N} the smaller the
fluctuations around \code{c}, and vice versa.}

\item{output}{Character; output as "vector" (default) for single values of
the K-copula, or "matrix" for the full K-copula.}

\item{method}{Character; method to be used for
\code{pkcopula(..., output = "vector")}.
If \code{method = "interpolate"} (default), values are computed by
interpolating the bivariate K-copula \emph{distribution function}
(computationally faster); returns \code{NA}, if \code{u, v} are out of
range (here: outside of \eqn{[.025, .975]}).
If \code{method = "integrate"}, values are computed by integrating
the bivariate K-copula \emph{density} (computationally slower).}
}
\value{
\code{dkcopula} gives the density (PDF), \code{pkcopula}
    gives the distribution function (CDF) of the bivariate K-copula.
}
\description{
Density and distribution function of the bivariate K-copula
by Wollschläger and Schäfer (2016).
}
\examples{
## Parameters
u <- seq(.05, .95, .05)
v <- u
rho <- .2
N <- 4

## K-copula PDF
dkcopula(.5, .5, rho, N)

\donttest{
## Plot full K-copula PDF
kcopula_pdf <- dkcopula(u, v, rho, N, output = "matrix")
persp(u, v, kcopula_pdf)

## K-copula CDF
pkcopula(.5, .5, rho, N)

## Plot full K-copula CDF
kcopula_cdf <- pkcopula(u, v, rho, N, output = "matrix")
persp(u, v, kcopula_cdf)
}

}
\references{
Wollschläger, M. and Schäfer, R. (2016). Impact of nonstationarity on
    estimating and modeling empirical copulas of daily stock returns.
    \emph{Journal of Risk}, 19(1):1--23.
    \url{https://doi.org/10.21314/JOR.2016.342}.
    SSRN version: \url{https://ssrn.com/abstract=3533903}.

Chetalova, D., Wollschläger, M., and Schäfer, R. (2015).
    Dependence structure of market states.
    \emph{Journal of Statistical Mechanics: Theory and Experiment},
    2015(8):P08012. \url{https://doi.org/10.1088/1742-5468/2015/08/P08012}.
    SSRN version: \url{https://ssrn.com/abstract=3533951}.
}
\author{
Marcel Kremer, \email{marcel.kremer@uni-due.de}
}
\keyword{distribution}
\keyword{multivariate}
