% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{pandoc}
\alias{pandoc}
\alias{render_math_in_html}
\title{Renders math in HTML document}
\usage{
render_math_in_html(
  input,
  output = NULL,
  ...,
  throwOnError = FALSE,
  include_css = TRUE
)
}
\arguments{
\item{input}{path to the html input file}

\item{output}{path to the output html file, or NULL to return as string}

\item{...}{additional html rendering options passed to
\href{https://katex.org/docs/options.html}{katex.render}}

\item{throwOnError}{should invalid math raise an error in R? See \href{https://katex.org/docs/options.html}{katex options}}

\item{include_css}{automatically inject the required katex css in the html head}
}
\description{
Reads an html file and substitutes elements of class \code{"math display"} and
\code{"math inline"} with rendered html math. This is mainly intended as a
post-processing step for pandoc, which generates such html for equations.
As a result the math can be displayed without the need for including the
mathjax library in the html document.
}
\seealso{
Other katex: 
\code{\link{katex}},
\code{\link{math_to_rd}()}
}
\concept{katex}
