.onLoad <- function(libname, pkgname){
  library.dynam("kaps", package = pkgname, lib.loc = libname)
  return(invisible(0))
}

pairwise.test <- function(x,  data, formula, rho, adj, splits){
	# treat pre-determined range for predictors
	data$K <- x
	pair <- combnat(unique(x),2)
	#pair <- combn(unique(x),2)
	res <- matrix(NA, nrow = ncol(pair), ncol=3)
	for(i in 1:ncol(pair)){
		data.tmp <- data[data$K %in% pair[,i],]
		#if(splits == "LogRank"){
		tmp <- survdiff(formula = formula, data = data.tmp, rho = rho)
		res[i,1] <- tmp$chisq
		res[i,2] <- 1 - pchisq(tmp$chisq, 1)
		res[i,3] <- as.numeric(paste(pair[,i], collapse =""))
		#}
		#else if(splits == "maxstat"){
		#	class(formula) <- "formula"
		#	tmp <- maxstat.test(formula= formula, data = data.tmp, smethod="LogRank",
		#		pmethod="exactGauss",minprop = 0.01, maxprop = .99)
		#	res[i,1] <- tmp$statistic
		#	res[i,2] <- tmp$p.value
		#	if(is.na(res[i,2])) res[i,2] <- 0
		#}
	}
	# Adjsut P-values for Multiple Comparisons 
	res[,2] <- p.adjust(res[,2], method = adj)
	#if(cre == "pvalue") res <- res[which(res[,2] == max(res[,2])),,drop = FALSE]
	#else if(cre == "chisq") res <- res[which(res[,1] == min(res[,1])),, drop = FALSE]
	index <- which(res[,1] == min(res[,1]))
	res <- res[index,,drop = FALSE]
	if(nrow(res) >=2) res = res[1,, drop = FALSE] 
	return(res)
}
 
group.sel <- function(x.vec,pt, K, mindat, data, f, minors){
	### find their groups automatically
	if(length(unique(x.vec)) < K) stop("The # of unique x must be larger than # of groups.")
	candid.pt <- combnat(pt, (K-1))
	#candid.pt <- combn(pt, (K-1))
	nr <- length(x.vec)
	cfun <- function(candid, nr, x.vec, mindat,formula){
		nc <- length(candid)
		gClass <- matrix(NA, ncol = nc, nrow = nr)
		gClass <- sapply(candid, function(x,y) y > x, y = x.vec)
		where <- apply(gClass, 1, sum)
		where <- where + 1
		if(length(unique(where)) != K) return(c(NA,NA,NA))
		if(all(table(where) > mindat)) {
			test.tmp <- pairwise.test(where, data, formula, rho = minors@rho, adj = minors@p.adjust.methods, splits = minors@splits)
			return(test.tmp)
			
		}
		else return(c(NA,NA,NA))
	}
	result <- apply(candid.pt, 2, cfun, nr = nr, x.vec = x.vec, mindat = mindat, formula = f) 
	if(all(is.na(result))) {
		cat("You must modify K (less than",K,") or mindat (greater than",mindat,"). \n ")
		stop("This parameters does not meet the minimum sample rule in the subgroup.")
	}
	index <- which(result[1,] == max(result[1,],na.rm = TRUE))
	if(length(index) >=2) index <- index[1]
	##allocate subgroup vector
	gClass <- matrix(NA, ncol = K, nrow = nr)
	gClass <- sapply(candid.pt[,index], function(x,y) y > x, y = x.vec)
	where <- apply(gClass, 1, sum) + 1
	gc(reset = TRUE)
	return(list(index = index, test = result, where = where))
}
