% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_multinormal.R
\name{multi_normal_gamma_pred}
\alias{multi_normal_gamma_pred}
\title{update_multi_NG_chol
multi_normal_gamma_pred}
\usage{
multi_normal_gamma_pred(
  conj.param,
  outcome = NULL,
  parms = list(),
  pred.cred = 0.95
)
}
\arguments{
\item{conj.param}{list or data.frame: The parameters of the conjugated distribution (Normal-Gamma) of the linear predictor.}

\item{outcome}{numeric or matrix (optional): The observed values at the current time.}

\item{parms}{list (optional): A list of extra parameters for the model. Not used in this function.}

\item{pred.cred}{numeric: the desired credibility for the credibility interval.}
}
\value{
A list containing the following values:
\itemize{
   \item pred numeric/matrix: the mean of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item var.pred numeric/matrix: the variance of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icl.pred numeric/matrix: the percentile of 100*((1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icu.pred numeric/matrix: the percentile of 100*(1-(1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item log.like numeric: the The log likelihood for the outcome given the conjugated parameters.
}
}
\description{
update_multi_NG_chol
multi_normal_gamma_pred
}
\seealso{
Other auxiliary functions for a Normal outcome: 
\code{\link{convert_multi_NG_Normal}()},
\code{\link{normal_pred}()},
\code{\link{update_Normal}()}
}
\concept{auxiliary functions for a Normal outcome}
\keyword{internal}
