% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{get_joyn_options}
\alias{get_joyn_options}
\title{Get joyn options}
\usage{
get_joyn_options(env = .joynenv, display = TRUE, option = NULL)
}
\arguments{
\item{env}{environment, which is joyn environment by default}

\item{display}{logical, if TRUE displays (i.e., print) info on joyn options and
corresponding default and current values}

\item{option}{character or NULL. If character, name of a specific joyn option.
If NULL, all joyn options}
}
\value{
joyn options and values invisibly as a list
}
\description{
This function aims to display and store info on joyn options
}
\examples{
\dontrun{

# display all joyn options, their default and current values
joyn:::get_joyn_options()

# store list of option = value pairs AND do not display info
joyn_options <- joyn:::get_joyn_options(display = FALSE)

# get info on one specific option and store it
joyn.verbose <- joyn:::get_joyn_options(option = "joyn.verbose")

# get info on two specific option
joyn:::get_joyn_options(option = c("joyn.verbose", "joyn.reportvar"))

}
}
\seealso{
JOYn options functions
\code{\link{set_joyn_options}()}
}
\concept{options}
