% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_bib.R
\name{unique_bib}
\alias{unique_bib}
\title{Delete duplicate.}
\usage{
unique_bib(tib, on = "keybib", retent_method = c("namin", "first", "last"))
}
\arguments{
\item{tib}{A tilbbe.}

\item{on}{character, A column in a tibble data frame,The default is \code{keybib}}

\item{retent_method}{character, Keep an entry from a duplicate in some way.
\describe{
\item{"namin"}{If it is repeated, the row containing the smallest number of NA values is retained. If there are multiple minimum values, the first one is retained}
\item{"first"}{If repeated, keep the first item}
\item{"last"}{If repeated, keep the last item}
}}
}
\value{
A \code{tibble}.
}
\description{
Delete duplicates based on a column (\code{keybib}).
}
\examples{
# Read from .bib file:
require(journalabbr)
path1 = system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
path2 = system.file("extdata", "testfile_3.bib", package = "journalabbr", mustWork = TRUE)
path3 = system.file("extdata", "testfile_4.bib", package = "journalabbr", mustWork = TRUE)
tib1 <- read_bib2tib(path1)
tib2 <- read_bib2tib(path2)
tib3 <- read_bib2tib(path3)
df = rbind_bib(tib1,tib2,fill=TRUE)
df1 = rbind_bib(tib1,tib2,tib3,fill=TRUE)
m1 = unique_bib(df1,retent_method='namin')
m2 = unique_bib(df1,retent_method='first')
m3 = unique_bib(df1,retent_method='last')
identical(m1,m2)
identical(m1,m3)
identical(m2,m3)
}
