% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{igrepHas}
\alias{igrepHas}
\title{vector contains any case-insensitive grep match}
\usage{
igrepHas(
  pattern,
  x = NULL,
  ignore.case = TRUE,
  minCount = 1,
  naToBlank = FALSE,
  ...
)
}
\arguments{
\item{pattern}{the grep pattern to use with \code{base::grep()}}

\item{x}{vector to use in the grep}

\item{ignore.case}{logical default TRUE, meaning the grep will be performed
in case-insensitive mode.}

\item{minCount}{integer minimum number of matches required to return TRUE.}

\item{naToBlank}{logical whether to convert NA to blank, instead of
allowing grep to handle NA values as-is.}

\item{...}{additional arguments are ignored.}
}
\value{
logical indicating whether the grep match criteria were met,
TRUE indicates the grep pattern was present in minCount or more
number of entries.
}
\description{
vector contains any case-insensitive grep match
}
\details{
This function checks the input vector for any elements matching the
grep pattern. The grep is performed case-insensitive (igrep). This function
is particularly useful when checking function arguments or object class,
where the class(a) might return multiple values, or where the name of
the class might be slightly different than expected, e.g. data.frame,
data_frame, DataFrame.
}
\examples{
a <- c("data.frame","data_frame","tibble","tbl");
igrepHas("Data.*Frame", a);
igrepHas("matrix", a);

}
\seealso{
\code{base::grep()}

Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrep}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unigrep}()},
\code{\link{unvigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
