% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jabr_fetch.R
\name{jabr_fetch}
\alias{jabr_fetch}
\title{Fetch dataset}
\usage{
jabr_fetch(id, keep_title = TRUE, as = "table")
}
\arguments{
\item{id}{The character id of dataset. It accepts single id or multiple ids. Non-matched id(s) will be ignored.}

\item{keep_title}{Whether to keep the dataset title in result. If the result is a table, the title is saved in "title" column. If the result is a list, the title is saved as list name.}

\item{as}{Applicable for multiple \code{id}. If \code{as = "table"}, the fetched datasets will be saved in "dataset" column with list-column type where you can run \code{tidyr::unnest()} afterwards. Otherwise the fetched datasets will be saved as list.}
}
\value{
A tibble or list of tibble.
}
\description{
Download and parse the dataset available at Open Data Jawa Barat into R.
}
\examples{
\donttest{
library(jabr)

(x <- jabr_list_dataset())


# for example, we want to fetch data about number of application available in west java.
# The id of this data is "3a51a670".
jabr_fetch("3a51a670")
}

}
