% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lpSetupCriterionBoot}
\alias{lpSetupCriterionBoot}
\title{Configure LP environment for specification testing}
\usage{
lpSetupCriterionBoot(env, sset, orig.sset, orig.criterion,
  criterion.tol = 0, setup = TRUE)
}
\arguments{
\item{env}{the LP environment}

\item{sset}{list of IV-like estimates and the corresponding gamma
terms.}

\item{orig.sset}{list, only used for bootstraps. The list caontains
the gamma moments for each element in the S-set, as well as the
IV-like coefficients.}

\item{orig.criterion}{scalar, only used for bootstraps. This is the
minimum criterion from the original sample.}

\item{criterion.tol}{tolerance for violation of observational
equivalence, set to 0 by default.}

\item{setup}{boolean. If \code{TRUE}, the function will modify the
LP environment so that the LP solver can obtain the test
statistic for the specification test. If \code{FALSE}, then it
will undo the changes made by the function if \code{setup =
TRUE}.}
}
\value{
Nothing, as this modifies an environment variable to save
    memory.
}
\description{
This function re-centers various objects in the LP environment so
that a specification test can be performed via the bootstrap. The
LP model must be passed as an environment variable, under the entry
\code{$lpobj}. See \code{\link{lpSetup}}.
}
