% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_coefs}
\alias{get_coefs}
\title{Get coefficients for the parametric terms (intercepts and random slopes).}
\usage{
get_coefs(model, se = TRUE)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{se}{Logical: whether or not to return the standard errors.}
}
\value{
The coefficients of the parametric terms.
}
\description{
Wrapper around the function \code{\link[stats]{coef}}, 
and loosely based on \code{\link[mgcv]{summary.gam}}. This function 
provides a much faster alternative for \code{summary(model)$p.table}.
The function \code{\link[mgcv]{summary.gam}}) may take considerably 
more time for large models, because it additionally needs to calculate 
estimates for the smooth term table.
}
\examples{
data(simdat)

# Condition as factor, to have a random intercept
# for illustration purposes:
simdat$Condition <- as.factor(simdat$Condition)

# Model with random effect and interactions:
m1 <- bam(Y ~ Group * Condition + s(Time),
    data=simdat)

# extract all parametric coefficients:
get_coefs(m1)
# calculate t-values:
test <- get_coefs(m1)
test <- cbind(test, test[,1] / test[,2] )
colnames(test)[3] <- 't-value'
test

# get_coefs returns the same numbers as shown in the parametric summary:
summary(m1)
# get_coefs is based on the function coef. This function returns 
# values of all coefficients, and does not provide SE:
coef(m1)

}
\seealso{
Other Model predictions: 
\code{\link{get_difference}()},
\code{\link{get_fitted}()},
\code{\link{get_modelterm}()},
\code{\link{get_predictions}()},
\code{\link{get_random}()}
}
\author{
Jacolien van Rij
}
\concept{Model predictions}
