% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{report_stats}
\alias{report_stats}
\title{Returns a description of the statistics of the smooth terms for reporting.}
\usage{
report_stats(model, summary = NULL,
  print.summary = getOption("itsadug_print"))
}
\arguments{
\item{model}{A gam or bam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{summary}{Optionally include the summary of the model when available, which may speed up the process for large models.}

\item{print.summary}{Logical: whether or not to print the output.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}
}
\description{
Returns a description of the statistics of the smooth terms 
for reporting.
}
\examples{
data(simdat)

# model without random effects:
m1 <- bam(Y ~ te(Time, Trial), data=simdat)
report_stats(m1)
# save report for later use:
report <- report_stats(m1, print.summary=FALSE)
report[3,2]

}
\author{
Jacolien van Rij
}
\seealso{
Other Testing for significance: \code{\link{compareML}},
  \code{\link{plot_diff2}}, \code{\link{plot_diff}},
  \code{\link{wald_gam}}
}

