% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_error}
\alias{plot_error}
\title{Utility function}
\usage{
plot_error(x, fit, se.fit, se.fit2 = NULL, shade = FALSE, f = 1,
  col = "black", ci.lty = NULL, ci.lwd = NULL, border = FALSE,
  alpha = 0.25, ...)
}
\arguments{
\item{x}{Vector with values on x-axis.}

\item{fit}{Vector with values on y-axis.}

\item{se.fit}{Vector with standard error; or when \code{se.fit2}
is provided, \code{se.fit} specifies upper values confidence
interval.}

\item{se.fit2}{Optional: lower values confidence interval.}

\item{shade}{Logical: whether or not to produce shaded regions as 
confidence bands.}

\item{f}{Factor for converting standard error in confidence intervals. 
Defaults to 1. Use 1.96 for 95\% CI, and 2.58 for 99\% CI.}

\item{col}{Color for lines and confindence bands.}

\item{ci.lty}{Line type to be used for the error lines, see 
\code{\link[graphics]{par}}.}

\item{ci.lwd}{Line type to be used for the error lines, see 
\code{\link[graphics]{par}}.}

\item{border}{The color to draw the border for the shaded confidence 
interval. The default, FALSE, omits borders.}

\item{alpha}{Transparency of shaded area. Number between 0 
(completely transparent) and 1 (not transparent).}

\item{...}{Optional arguments for the lines and shaded area.}
}
\description{
Plot line with confidence intervals.
}
\examples{
data(simdat)

# Use aggregate to calculate mean and standard deviation per timestamp:
avg <- aggregate(simdat$Y, by=list(Time=simdat$Time),
    function(x){c(mean=mean(x), sd=sd(x))})
head(avg)
# Note that column x has two values in each row (a more intuitive way 
# to calculate different measures at the same time is implemented in 
# ddply (package plyr)):
head(avg$x)
head(avg$x[,1])

# Plot line and standard deviation:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'])
# Change layout:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   shade=TRUE, lty=3, lwd=3)

# Show difference with 0:
x <- find_difference(avg$x[,'mean'], avg$x[,'sd'], xVals=avg$Time)
# Add arrows:
abline(v=c(x$start, x$end), lty=3, col='red')
arrows(x0=x$start, x1=x$end, y0=-5, y1=-5, code=3, length=.1, col='red')

# Use of se.fit2 for asymmetrical error bars:
avg$cu <- avg$x[,'mean'] + .25*avg$x[,'sd']
avg$cl <- avg$x[,'mean'] - avg$x[,'sd']
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], se.fit=avg$cu, se.fit2=avg$cl, col='red')

# Some layout options:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   lty=3, lwd=1, ci.lty=1, ci.lwd=3)
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   shade=TRUE, lty=3, lwd=3)
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   shade=TRUE, lty=1, lwd=3, ci.lwd=3, border='red')
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'], 
   shade=TRUE, lty=1, lwd=3, density=10, ci.lwd=3)

}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_image}}, \code{\link{plotsurface}},
  \code{\link{rug_model}}
}

