% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_predictions}
\alias{get_predictions}
\title{Get model predictions for specific conditions.}
\usage{
get_predictions(model, cond = NULL, se = TRUE, f = 1.96,
  rm.ranef = NULL, print.summary = TRUE)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{cond}{A named list of the values to use for the predictor terms.
Variables omitted from this list will have the closest observed value to
the median for continuous variables, or the reference level for factors.}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is TRUE. Alternatively a string (or vector of strings) with the
name of the random effect(s) to remove.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor. Defaults to TRUE.}
}
\value{
A data frame with estimates and optinally errors.
}
\description{
Get model predictions for specific conditions.
}
\examples{
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_difference}};
  \code{\link{get_modelterm}}; \code{\link{get_random}}
}

