% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_projection-simulation.R
\name{sample_from}
\alias{sample_from}
\title{Generate samples from a network model}
\usage{
sample_from(
  nm,
  at,
  dt = NULL,
  grid_size = NULL,
  end = NULL,
  error.draws = 1,
  cached_ts = NULL,
  cached_ee = NULL
)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{at}{Vector of time values at which the samples should be taken.}

\item{dt, grid_size}{Time step size or grid points, respectively.}

\item{end}{Final timepoint used in the projections.}

\item{error.draws}{Integer, number of draws from the error distribution for
each sample (default: 1).}

\item{cached_ts, cached_ee}{Used for optimization by other functions, not for
use by the package user.}
}
\value{
A tibble containing the generated samples.
}
\description{
Generate samples from a network model
}
\examples{
library(magrittr)
mod <- new_networkModel() \%>\%
   set_topo("NH4 -> algae -> daphnia -> NH4")
inits <- tibble::tribble(
     ~comps, ~sizes, ~props, ~treatment,
      "NH4",    0.2,    0.8,    "light",
    "algae",      1,  0.004,    "light",
  "daphnia",      2,  0.004,    "light",
      "NH4",    0.5,    0.8,     "dark",
    "algae",    1.2,  0.004,     "dark",
  "daphnia",    1.3,  0.004,     "dark")
mod <- set_init(mod, inits, comp = "comps", size = "sizes",
                prop = "props", group_by = "treatment")
mod <- add_covariates(mod, upsilon_NH4_to_algae ~ treatment)
mod <- mod \%>\%
  set_params(c("eta" = 0.2, "lambda_algae" = 0, "lambda_daphnia" = 0,
               "lambda_NH4" = 0, "upsilon_NH4_to_algae|light" = 0.3,
               "upsilon_NH4_to_algae|dark" = 0.1,
               "upsilon_algae_to_daphnia" = 0.13,
               "upsilon_daphnia_to_NH4" = 0.045, "zeta" = 0.1))
spl <- mod \%>\% sample_from(at = 1:10)
spl

}
