% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/triangle_soil.R
\docType{methods}
\name{triangle_soil}
\alias{triangle_soil}
\alias{triangle_soil_hypres}
\alias{triangle_soil_folk}
\alias{triangle_soil_shepard}
\alias{triangle_soil_usda}
\title{Soil Texture Triangle}
\usage{
triangle_soil_hypres(labels = TRUE, symbol = FALSE, ...)

triangle_soil_folk(labels = TRUE, symbol = FALSE, ...)

triangle_soil_shepard(labels = TRUE, symbol = FALSE, ...)

triangle_soil_usda(labels = TRUE, symbol = FALSE, ...)
}
\arguments{
\item{labels}{A \code{\link{logical}} scalar: should labels be displayed?}

\item{symbol}{A \code{\link{logical}} scalar: should symbol be used instead of full
labels? Only used if \code{labels} is \code{TRUE}.}

\item{...}{Further arguments to be passed to \code{\link[graphics:polygon]{graphics::polygon()}}.}
}
\description{
Soil Texture Triangle
}
\examples{
## HYPRES soil texture
ternary_plot(NULL, xlab = "sand", ylab = "silt", zlab = "clay")
triangle_soil_hypres()

## USDA (1951) soil texture
ternary_plot(NULL, xlab = "sand", ylab = "silt", zlab = "clay")
triangle_soil_usda(symbol = TRUE)

## Folk (1954) soil texture
ternary_plot(NULL, xlab = "sand", ylab = "silt", zlab = "clay")
triangle_soil_folk(symbol = TRUE)

## Shepard (1954) soil texture
ternary_plot(NULL, xlab = "sand", ylab = "silt", zlab = "clay")
triangle_soil_shepard()
}
\seealso{
Other charts: 
\code{\link{triangle_phase_cas}()}
}
\author{
N. Frerebeau
}
\concept{charts}
