% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluationCriteria.R
\name{weight_of_evidence}
\alias{weight_of_evidence}
\title{Weight of evidence}
\usage{
weight_of_evidence(data)
}
\arguments{
\item{data}{A dataframe with the names of the models in the first column and
their AIC values in the second column.}
}
\value{
A dataframe with the names of the analysed models, their AIC
  differences with respect to the best model and the w_i of each one.
}
\description{
\code{weight_of_evidence} calculates the weight of evidence of a set of
nested models.
}
\details{
Calculates the weight of evidence in favor of model i being the actual
Kullback-Leibler best model given a set of models R for your data.

\deqn{w_i = exp( - 1/2 * \Delta_i) / \Sigma exp( - 1/2 * \Delta_r)}
  \deqn{r = 1, R}
}
\examples{
models <- c("Best_3k", "Best_4k", "Best_5k", "Best_6k", "Best_7k",
  "Best_8k", "Best_9k")

  aks <- c(2977.852, 2968.568, 2957.384, 2952.618,
  2949.128, 2947.038, 2943.480)

  weight_of_evidence(cbind(models, aks))

}
\references{
K. P.  Burnham, D. R. Anderson. \emph{Model selection and
  multimodel inference: a practical information-theoretic approach} (New
  York:Springer, ed. 2, 2002).
}
\seealso{
\code{\link{akaikeic}}
}
