% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writeISAtab}
\alias{writeISAtab}
\alias{writeInvestigationFile}
\alias{writeStudyFiles}
\alias{writeAssayFiles}
\title{Write ISA-Tab object.}
\usage{
writeISAtab(isaObject, path = getwd())

writeInvestigationFile(isaObject, path = getwd())

writeStudyFiles(
  isaObject,
  studyFilenames = getStudyFileNames(isaObject),
  path = getwd()
)

writeAssayFiles(
  isaObject,
  assayFilenames = unlist(getAssayFileNames(isaObject)),
  path = getwd()
)
}
\arguments{
\item{isaObject}{An object of the \code{\link{ISA-class}}.}

\item{path}{A character vector with the name of the directory to which the
file(s) should be written. The default value is the current working
directory.}

\item{studyFilenames}{A character vector indicating the study files that
should be written. Default all study files in isaObject are written.}

\item{assayFilenames}{A character vector indicating the assay files that
should be written. Default all assay files in isaObject are written.}
}
\value{
No return value, files are written to path.
}
\description{
Write ISA-Tab object to files. The investigation file, study files and assay
files are written to the folder specified in \code{path}.\cr\cr
It is also possible to write only the investigation file, one or more
study files, or one or more assay files using the respective functions.
}
\examples{
## Read example Atwell data set.
isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
                                          package = "isatabr")))

## Write content of ISA object to a temporary directory.
writeISAtab(isaObject = isaObject1,
           path = tempdir())

## Write investigation file to a temporary directory.
writeInvestigationFile(isaObject = isaObject1,
                       path = tempdir())

## Write study file to a temporary directory.
writeStudyFiles(isaObject = isaObject1,
                studyFilenames = "s_study1.txt",
                path = tempdir())

## Write assay file to a temporary directory.
writeAssayFiles(isaObject = isaObject1,
                assayFilenames = "a_study1.txt",
                path = tempdir())

}
