% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{summary.cat_output}
\alias{summary.cat_output}
\title{Summarizes the raw output of cat_sim}
\usage{
\method{summary}{cat_output}(
  object,
  ...,
  cols = c("examinee_id", "true_ability", "est_ability", "se", "test_length")
)
}
\arguments{
\item{object}{This is a cat_output object or a list object containing
elements that are "cat_output" class.}

\item{...}{Additional arguments.}

\item{cols}{The variables that will be included in the summary. There should
be at least one column. Available columns are:
\describe{
  \item{examinee_id}{Examinee ID's if named true theta vector
    has been provided to \code{cat_sim()} function.}
  \item{true_ability}{True ability of the simulee}
  \item{est_ability}{Ability Estimate}
  \item{se}{Standard Error of the ability estimate}
  \item{test_length}{Test length.}
  \item{bias}{The difference between true ability and ability
    estimate}
  \item{mse}{Mean squared error}
  \item{mean_qip}{Mean of Quality of Item Pool Index.
          See \code{qip_index()} function for details.}
  \item{median_qip}{Median of Quality of Item Pool Index.
          See \code{qip_index()} function for details.}
  \item{min_qip}{Minimum value of Quality of Item Pool Index.
          See \code{qip_index()} function for details.}
  \item{max_qip}{Maximum value of Quality of Item Pool Index.
          See \code{qip_index()} function for details.}
}}
}
\value{
This function returns a summary data frame of adaptive tests. Each
row will represent a different adaptive test.
}
\description{
This function summarizes a list consist of cat_output objects.
It returns a summary data frame of the CAT simulation.
}
\examples{
n <- 100 # number of items
ip <- generate_ip(n = n,
                  content = sample(c("Algebra", "Arithmetic", "Geometry"),
                                   n, replace = TRUE))
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
cat_data <- cat_sim(true_ability = rnorm(5), cd = cd)
summary(cat_data)

# Get only selected columns
summary(cat_data, cols = c("examinee_id", "true_ability", "est_ability",
                           "bias"))
summary(cat_data, cols = c("examinee_id", "true_ability", "est_ability",
                           "mean_qip", "median_qip", "min_qip"))
}
\seealso{
\code{\link{cat_sim}}
}
\author{
Emre Gonulates
}
