% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_analysis.R
\name{biserial}
\alias{biserial}
\title{Calculate biserial correlation}
\usage{
biserial(score, total_score, method = "default")
}
\arguments{
\item{score}{Item scores of each examinee for which biserial correlation will
be calculated}

\item{total_score}{Total score of each examinee}

\item{method}{Type of the biserial correlation calculation method.
\describe{
  \item{\strong{"default"}}{The most common way to calculate biserial
  correlation. }
  \item{\strong{"point-biserial"}}{Calculate point-biserial correlation. }
  \item{\strong{"clemans-lord"}}{Modified biserial correlation value based
    on Clemans (1958) and Lord (1962).}
  \item{\strong{"brogden"}}{Modified biserial correlation value based on:
    Brogden (1949)}
  \item{\strong{"rank"}}{Rank biserial correlation value based on Cureton
    (1968).}
  }}
}
\value{
Biserial correlation value
}
\description{
Calculate biserial correlation
}
\examples{
# The example is from Salkind, Rasmussen (2007) Encyclopedia of measurement
# and statistics, pages 94-97
score <- c(rep(0, 16), rep(1, 22))
total_score <- c(87, 90, 94, 94, 97, 103, 103, 104, 106, 108, 109, 109, 109,
                 112, 119, 132, 100, 103, 103, 106, 112, 113, 114, 114, 118,
                 119, 120, 120, 124, 133, 135, 135, 136, 141, 155, 157, 159,
                 162)
# Calculate biserial correlation
biserial(score, total_score)
# Calculate point-biserial correlation
biserial(score, total_score, method = "point-biserial")
# Calculate modified biserial correlation (based on Brogden (1949))
biserial(score, total_score, method = "brogden")
# Calculate modified biserial correlation (Clemans-Lord)
biserial(score, total_score, method = "clemans-lord")

}
\references{
Brogden, H. E. (1949). A new coefficient: Application to biserial
  correlation and to estimation of selective efficiency. Psychometrika, 14,
  169-182.

Clemans, W. V. (1958) An index of item-criterion relationship. Educational
  and Psychological Measurement, 18, 167-172.

Cureton, E. E. (1968). Rank biserial correlation when ties are present.
  Educational and Psychological Measurement, 28, 77-79.

Kraemer, H. C. (1981). Modified biserial correlation coefficients.
  Psychometrika, 46(3), 275-282.

Lord, F. M. (1963). Biserial estimates of correlation. Psychometrika, 28,
  81–85.
}
\author{
Emre Gonulates
}
