% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_xy.R
\name{sort_xy}
\alias{sort_xy}
\title{Sorting \code{y} column in data by \code{x}.}
\usage{
sort_xy(data, x, y, sort = "none", .fun = mean, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{sort}{If \code{"ascending"} (default), \code{x}-variable factor levels will be
sorted based on increasing values of \code{y}-variable. If \code{"descending"}, the
opposite. If \code{"none"}, no sorting will happen.}

\item{.fun}{n summary function. It should take one vector for
\code{fct_reorder}, and two vectors for \code{fct_reorder2}, and return a single
value.}

\item{...}{Currently ignored.}
}
\description{
Sorting \code{y} column in data by \code{x}.
}
\examples{
sort_xy(ggplot2::msleep, vore, brainwt, sort = "ascending")
}
