% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{ip_operators}
\alias{ip_operators}
\alias{\%<<\%}
\alias{\%>>\%}
\title{Operators for IP addresses}
\description{
\code{\link{ip_address}} vectors support the following operators:
\itemize{
\item bitwise logic operators: \code{!} (NOT), \code{&} (AND), \code{|} (OR), \code{^} (XOR)
\item bitwise shift operators: \verb{\%<<\%} (left shift), \verb{\%>>\%} (right shift)
\item arithmetic operators: \code{+} (addition), \code{-} (subtraction)
}
}
\examples{
# use ip_to_binary() to understand these examples better

# bitwise NOT
!ip_address("192.168.0.1")

# bitwise AND
ip_address("192.168.0.1") & ip_address("255.0.0.255")

# bitwise OR
ip_address("192.168.0.0") | ip_address("255.0.0.255")

# bitwise XOR
ip_address("192.168.0.0") ^ ip_address("255.0.0.255")

# bitwise shift left
ip_address("192.168.0.1") \%<<\% 1

# bitwise shift right
ip_address("192.168.0.1") \%>>\% 1

# addition of integers
ip_address("192.168.0.1") + 10

# subtraction of integers
ip_address("192.168.0.1") - 10
}
