% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_coefficient_matrix_create.R
\name{output_coefficient_matrix_create}
\alias{output_coefficient_matrix_create}
\title{Create an output coefficient matrix}
\usage{
output_coefficient_matrix_create(data_table, total = "tfu", digits = NULL)
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, 
a margins or tax table retrieved by the \code{\link{iotable_get}}. 
In case you use \code{type="tfu"} you need to input a
full iotable, create by the \code{\link{iotable_get}}, because 
the final demand column is in the second quadrant of the IOT.}

\item{total}{The \code{output='total'} (or CPA_TOTAL, depending on the 
names in your table, default) returns the output coefficients
for products (intermediates) while the \code{final_demand} returns output 
coefficients for final demand. See 
\href{https://ec.europa.eu/eurostat/documents/3859598/5902113/KS-RA-07-013-EN.PDF/b0b3d71e-3930-4442-94be-70b36cea9b39}{Eurostat Manual of Supply, Use and Input-Output Tables}
p495 and p507.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}
}
\value{
An output coefficient matrix of data.frame class. 
The column names are ordered, and the row names are in the 
first, auxiliary metadata column.
}
\description{
Create an output coefficient matrix from the input flow matrix or a symmetric
input-output table.
}
\details{
The output coefficients may be interpreted as the market shares of products
in total output. If there are zero values in present, they will be changed to 
0.000001 and you will get a warning. Some analytical equations cannot be 
solved with zero elements. You either have faulty input data, or you have 
to use some sort of data modification to carry on your analysis.
}
\examples{
data_table <- iotable_get() 

output_coefficient_matrix_create (data_table = data_table, 
                                  total = 'tfu',
                                  digits = 4)
}
