% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_germany.R
\docType{data}
\name{germany_1990}
\alias{germany_1990}
\title{Simple input-output table for Germany, 1990.}
\format{
A data frame with 228 observations and 10 variables.
\describe{
  \item{prod_na}{Technology codes in row names, following the Eurostat convention.}
  \item{prod_na_lab}{Longer labels for t_rows2}
  \item{induse}{Column labels, following the Eurostat convention with differences.}
  \item{iotables_row}{Row labels, i.e. to be used in key column, for iotables package abbreviations}
  \item{iotables_col}{Column labels for iotables package abbreviations}
  \item{values}{The actual values of the table in million euros}  
  \item{unit}{MIO_EUR, the same as Eurostat}
  \item{unit_lab}{Million euros. Eurostat usually has euro and national currency unit values, too.}
  \item{geo}{ISO / Eurostat country code for Germany, i.e. DE}
  \item{geo_lab}{ISO / Eurostat country name, Germany}
  \item{time}{Date of the SIOT}     
}
}
\source{
\href{http://ec.europa.eu/eurostat/documents/3859598/5902113/KS-RA-07-013-EN.PDF/b0b3d71e-3930-4442-94be-70b36cea9b39?version=1.0}{Eurostat Manual of Supply, Use and Input-Output Tables} p 492
}
\usage{
data(germany_1990)
}
\description{
For testing purposes a well documented example data set is used from the Eurostat manual.
The table in the Eurostat manual is brought to the format used by the Eurostat database.
It is a small dataset for examples, but it is also instructive to understand how Eurostat
stores the highly structured SIOTs in long-form tidy datasets. 
The labels were slightly alterred to reflect the transition from the vocabulary
of ESA95 to ESA2010 since the publication of the Manual.
}
\seealso{
Other Validation datasets: 
\code{\link{netherlands_2006}},
\code{\link{uk_2010_data}},
\code{\link{uk_test_results}}
}
\concept{Validation datasets}
\keyword{datasets}
