% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_frailty_data.R
\name{sim_frailty}
\alias{sim_frailty}
\title{Generates a interval censored dataset using frailty cure rate model}
\usage{
sim_frailty(N, theta = c(-1, 1, 0), beta = c(0, 0.5), A = 5, B = 15,
  prob = 0.5)
}
\arguments{
\item{N}{Size of the sample to be generated.}

\item{theta}{Three parameters associated with the cure linear predictor.}

\item{beta}{Two parameters associated with the hazard function.}

\item{A}{A positive number representing a fixed right censoring.}

\item{B}{A positive number which multiplies an uniform random variable,
defining another right censoring case.}

\item{prob}{Probability that individual presents treatment T1 (baseline is
T0).}
}
\value{
A generated dataset with columns: \code{Z}, the actual event time;
  \code{L}, the leftmost limit of the censored interval; \code{R}, the
  rightmost limit of the censored interval; \code{delta}, the failure
  indicator; \code{xi1}, the treatment covariate assuming 1 with probability
  \code{prob} and 0 otherwise; \code{xi2}, second variable generated by a
  standard normal distribution.
}
\description{
\code{sim_frailty} returns a dataset generated by the cure rate frailty
model.
}
\examples{
sim_frailty(20)
}

