% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrcubspline.R
\name{rcsHR}
\alias{rcsHR}
\title{Restricted cubic spline interaction HR}
\usage{
rcsHR(
  var2values,
  model,
  data = NULL,
  var1,
  var2,
  ci = TRUE,
  conf = 0.95,
  ci.method = "delta",
  ci.boot.method = "perc",
  R = 100,
  parallel = "multicore",
  ...
)
}
\arguments{
\item{var2values}{numeric vector of var2 points to estimate}

\item{model}{model of class cph or coxph. If data is NULL, the function expects to find the data in model$x.}

\item{data}{data used in the model. If absent, we will attempt to recover the data from the model. Only used for bootstrap and coxph models}

\item{var1}{variable that increases by 1 unit from 0.}

\item{var2}{variable to spline. var2values belong to var2}

\item{ci}{calculate 95\% CI?}

\item{conf}{confidence level. Default 0.95}

\item{ci.method}{confidence interval method. "delta" performs delta method. "bootstrap" performs bootstrapped CI (slower)}

\item{ci.boot.method}{one of the available bootstrap CI methods from \code{\link[boot]{boot.ci}}. Default percentile}

\item{R}{number of bootstrap samples if ci.method = "bootstrap". Default 100}

\item{parallel}{can take values "no", "multicore", "snow" if ci.method = "bootstrap". Default multicore}

\item{...}{other parameters for boot}
}
\value{
if ci = FALSE, a dataframe with initial values and HR
, if ci = TRUE a dataframe with 5 columns, initial values, HR, lower CI, upper CI and SE
}
\description{
Generate HR values in a Cox model for a 1 unit increase in a variable at
specified points of another interacting variable splined with rcs(df = 3)
}
\examples{
library(survival)
library(rms)
data(cancer)
myformula <- Surv(time, status) ~ ph.karno + ph.ecog + rcs(age,3)*sex
model <- cph(myformula , data = lung )
rcsHR( var2values = 40:80
       , model = model , data = lung , var1 ="sex", var2="age"
       , ci=TRUE , conf = 0.95 , ci.method = "delta")
}
