% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\docType{package}
\name{intRvals-package}
\alias{intRvals}
\alias{intRvals-package}
\title{Analysing time-ordered event data with missed observations}
\description{
\pkg{intRvals} calculates means and variances of arrival intervals (and arrival rates)
corrected for missed arrival observations, and compares means
 and variances of groups of interval data.
}
\details{
\subsection{General}{
The central function of package \pkg{intRvals} is
\code{\link{estinterval}}, which is used to estimate the
mean arrival interval (and its standard deviation) from interval
data with missed arrivals. This is
achieved by fitting the theoretical probability density
\code{\link{intervalpdf}} to the interval data

The package can be used to analyse general interval data where
intervals are derived from distinct arrival observations.
For example, the authors have used it to analyze dropping intervals
of grazing geese for estimating their faecal output.

Intervals are defined as the time between observed arrival events (e.g. the time between one excreted droppings to the next)
The package provides a way of taking into account missed observations
(e.g. defecations), which lead to occasional observed intervals at integer multiples of the
true arrival interval.
}
\subsection{Typical workflow}{
\enumerate{
  \item{Fit interval model \code{m} to an interval dataset \code{d} using \code{\link{estinterval}}, as in \code{m=estinterval(d)}}.
  \item{Visually inspect model fits using \code{\link{plot.intRvals}}, as in \code{plot(m)}}.
  \item{Use \code{\link{anova.intRvals}} to check whether the missed event probability was signficantly different from zero, as in \code{anova(m)}.}
  \item{Also use \code{\link{anova.intRvals}} to perform model selection between competing models \code{m1},\code{m2} for the same interval dataset \code{d}, as in \code{anova(m1,m2)}.}
  \item{Compare means and variances between different interval datasets \code{d1},\code{d2} using \code{\link{ttest}} and \code{\link{vartest}}.}
}
}
\subsection{Other useful functionality}{
\code{\link{fold}} provides functionality to fold observed intervals back to their fundamental interval

\code{\link{fundamental}} tests which intervals are fundamental, i.e. intervals not containing a missed arrival observation

\code{\link{interval2rate}} converts interval estimates to rates

\code{\link{partition}} estimates and tests for the presence of within-subject variation

\code{\link{intervalsim}} simulates a set of observed intervals

The package comes with a example interval dataset \code{\link{goosedrop}}

Please cite this package using the publication "Analysing time-ordered event data with missed observations, Ecology and Evolution, 2017" by Dokter et al.
}
}
\references{
Dokter, A.M., van Loon, E.E., Fokkema, W., Lameris, T.K, , Nolet, B.A. and van der Jeugd, H.P. 2017. Analysing time-ordered event data with missed observations, Ecology and Evolution, 2017, in press.

B\'{e}dard, J. & Gauthier, G. 1986. Assessment of faecal output in geese. Journal of Applied Ecology, 23, 77-90.

Owen, M. 1971. The Selection of Feeding Site by White-Fronted Geese in Winter. Journal of Applied Ecology 8: 905-917.
}
