% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch.R
\name{stitch}
\alias{stitch}
\title{Paired-end read stitching.}
\usage{
stitch(x, y, up = NULL, down = NULL, mindiff = 6, minoverlap = 16)
}
\arguments{
\item{x, y}{DNAbin objects with quality attributes (see \code{\link{readFASTQ}} to
generate these objects from fastq text files), representing the forward and
reverse reads to be stitched. These objects can be either vectors or lists.
In the latter case, the two objects must be equal length.}

\item{up, down}{forward and reverse primer sequences (either as concatenated
character strings or "DNAbin" objects).
Either both or neither should be provided (not one or the other).}

\item{mindiff}{the minimum difference in quality between two different base calls
for the higher quality call to be added to the consensus alignment. In cases where
the quality differences are less than this threshold, the ambiguity code "N" is added
to the consensus sequence. Defaults to 6.}

\item{minoverlap}{integer giving the minimum number of nucleotides that
should be shared between the forward and reverse sequence alignments.
Defaults to 16.}
}
\value{
a "DNAbin" object or a vector of concatenated character strings,
  depending on the input.
}
\description{
This function aligns forward and reverse reads generated from a
  2x amplicon sequencing platform, and produces a consensus sequence with
  maximum base-call quality scores attached as "quality" attributes.
}
\examples{
\donttest{
  ## download and extract example FASTQ file to temporary directory
  td <- tempdir()
  URL <- "https://www.dropbox.com/s/71ixehy8e51etdd/insect_tutorial1_files.zip?dl=1"
  dest <- paste0(td, "/insect_tutorial1_files.zip")
  download.file(URL, destfile = dest, mode = "wb")
  unzip(dest, exdir = td)
  x <- readFASTQ(paste0(td, "/COI_sample1_read1.fastq"), bin = FALSE)
  y <- readFASTQ(paste0(td, "/COI_sample1_read2.fastq"), bin = FALSE)
  z <- stitch(x, y)
  z[1]
  attr(z, "quality")[1]
}
}
\seealso{
\code{\link{readFASTQ}}.
}
\author{
Shaun Wilkinson
}
