% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddInsetMap.R
\name{AddInsetMap}
\alias{AddInsetMap}
\title{Add Inset Map to Plot}
\usage{
AddInsetMap(p, col = c("#D8D8D8", "#BFA76F"), main.label = list(label =
  NA, adj = NULL), sub.label = list(label = NA, adj = NULL),
  loc = "topright", inset = 0.02, width = NULL, e = NULL,
  bty = c("o", "n"))
}
\arguments{
\item{p}{'SpatialPolygons'.
Polygon describing the large map.}

\item{col}{'character' vector of length 2.
Colors for filling the large map polygon \code{p} and the smaller plot extent rectangle.}

\item{main.label}{'list'.
List with components \code{label} and \code{adj}.
The text label and position (x and y adjustment of the label) for the large map, respectively.}

\item{sub.label}{'list'.
Identical to the \code{main.label} argument but for the plot extent rectangle.}

\item{loc}{'character' string.
Position of the inset map in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{inset}{'numeric' vector of length 1 or 2, value is recycled as necessary.
Inset distance(s) from the margins as a fraction of the main plot region.
Defaults to 2 percent of the axis range.}

\item{width}{'numeric' number.
Width of the inset map in inches.}

\item{e}{'numeric' vector of length 4.
Extent of the smaller axis-aligned rectangle (relative to the larger map polygon).
Defaults to the user coordinate extent of the main plot region, see \code{par("usr")}.}

\item{bty}{'character' string.
Type of box to be drawn about the inset map.
A value of \code{"o"} (the default) results in a box and a value of \code{"n"} suppresses the box.}
}
\value{
Invisible \code{NULL}
}
\description{
Add an inset map to a plot.
}
\examples{
file <- system.file("extdata/county.geojson",
                    package = "inlmisc")[1]
county <- rgdal::readOGR(file)
ext <- c(-113.4005, -112.2764, 43.30, 44.11)
PlotMap(county, xlim = ext[1:2], ylim = ext[3:4],
        dms.tick = TRUE)
sp::plot(county, add = TRUE)
inlmisc::AddInsetMap(county, width = 2,
                     main.label = list("IDAHO", "adj" = c(0, -10)),
                     sub.label = list("Map area", "adj" = c(0, -4)),
                     loc = "topright")

}
\seealso{
\code{\link{PlotMap}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
