% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToScientific.R
\name{ToScientific}
\alias{ToScientific}
\title{Format for Scientific Notation}
\usage{
ToScientific(x, digits = NULL, type = c("latex", "plotmath"),
  na = as.character(NA), delimiter = "$", scipen = NULL,
  big.mark = ",", ...)
}
\arguments{
\item{x}{'numeric'.
Vector of numbers}

\item{digits}{'integer'.
Desired number of digits after the decimal point.}

\item{type}{'character'.
Specify \code{"latex"} to return numbers in the LaTeX markup language (default),
or \code{"plotmath"} to return as \code{\link[grDevices]{plotmath}} expressions.}

\item{na}{'character'.
String to be used for missing values (\code{NA}).
By default, no string substitution is made for missing values.}

\item{delimiter}{'character'.
Delimiter for LaTeX mathematical mode, inline (\code{$...$}) by default.
Does not apply to missing value strings.}

\item{scipen}{'integer'.
A penalty to be applied when deciding to format numeric values in scientific or fixed notation.
Positive values bias towards fixed and negative towards scientific notation:
fixed notation will be preferred unless it is more than \code{scipen} digits wider.
Specify \code{NULL} to format all numbers, with the exception of zero, in scientific notation.}

\item{big.mark}{'character'.
Mark inserted between every big interval before the decimal point.
By default, commas are placed every 3 decimal places for numbers larger than 999.}

\item{...}{Not used}
}
\value{
For \code{type = "latex"}, returns a 'character' vector of the same length as argument \code{x}.
  And for \code{type = "plotmath"}, returns an 'expression' vector of the same length as \code{x}.
}
\description{
This function formats numbers in scientific notation \eqn{m \times 10^{n}}{m x 10^n}.
}
\examples{
x <- c(-1e+09, 0, NA, pi * 10^(-5:5))
ToScientific(x, digits = 2L, na = "---")

ToScientific(x, digits = 2L, scipen = 0L)

x <- seq(0, 20000, by = 4000)
ToScientific(x, scipen = 0)

lab <- ToScientific(x, type = "plotmath", scipen = 0L)
i <- seq_along(x)
plot(i, type = "n", xaxt = "n", yaxt = "n", ann = FALSE)
axis(1, i, labels = lab)
axis(2, i, labels = lab)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
