% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddBubbles.R
\name{AddBubbles}
\alias{AddBubbles}
\title{Add Bubble Map to Plot}
\usage{
AddBubbles(x, y = NULL, z, zlim = NULL, inches = c(0, 0.2),
  scaling = c("perceptual", "mathematical"), bg.pos = "red",
  bg.neg = "blue", fg = NA, lwd = 0.25, cex = 0.7, format = NULL,
  draw.legend = TRUE, loc = c("bottomleft", "topleft", "topright",
  "bottomright"), inset = 0.02, breaks = NULL, break.labels = NULL,
  quantile.breaks = FALSE, make.intervals = FALSE, title = NULL,
  subtitle = NULL, add = TRUE)
}
\arguments{
\item{x, y}{numeric.
The x and y coordinates for the centers of the circle symbols.
They can be specified in any way which is accepted by \code{xy.coords}.}

\item{z}{numeric.
Attribute variable}

\item{zlim}{numeric.
Minimum and maximum \code{z} values that circle symbols are plotted;
defaults to the range of the finite values of \code{z}.}

\item{inches}{numeric.
Vector of length 2 specifying the radii limits for the drawn circle symbol.}

\item{scaling}{character.
Selects the proportional symbol mapping algorithm to be used;
either "perceptual" or "mathematical" scaling (Tanimura and others, 2006).}

\item{bg.pos}{character or function.
Fill color(s) for circle symbols corresponding to positive \code{z} values.
A color palette also may be specified.}

\item{bg.neg}{character or function.
Fill color(s) for circle symbols corresponding to negative \code{z} values.
A color palette also may be specified.}

\item{fg}{character.
Outer-line color for circle symbols.
Specify a value of \code{NA} to remove the symbols outer line, and
\code{NULL} to match the outer-line color with the symbols fill color.}

\item{lwd}{numeric.
Line width for drawing circle symbols}

\item{cex}{character.
Character expansion factor for legend labels}

\item{format}{character.
Formatting for legend values, see \code{\link{formatC}} for options.}

\item{draw.legend}{logical.
If true, a legend is drawn.}

\item{loc}{character.
Position of the legend in the main plot region:
"bottomleft", "topleft", "topright", or "bottomright" to denote scale location.}

\item{inset}{numeric.
Inset distance of the legend from the margins as a fraction of the main plot region.
Defaults to 2 percent of the axis range.}

\item{breaks}{numeric.
Set of finite breakpoints for the legend circle symbols.}

\item{break.labels}{character.
Vector of break labels with length equal to \code{breaks}.}

\item{quantile.breaks}{logical.
If true, \code{breaks} are set to the sample quantiles of \code{z}.}

\item{make.intervals}{logical.
If true, represent \code{z} within intervals.
See \code{\link{findInterval}} function for details.}

\item{title}{character.
Main title to be placed at the top of the legend.}

\item{subtitle}{character.
Legend subtitle to be placed below the main title.}

\item{add}{logical.
If true, circle symbols (and an optional legend) are added to an existing plot.}
}
\value{
Used for the side-effect of a bubble map drawn on the current graphics device.
}
\description{
This function can be used to add a bubble map to a plot.
Proportional circle symbols are used to represent spatial point data,
where symbol area varies in proportion to an attribute variable.
}
\examples{
n <- 50L
x <- cbind(runif(n, 1, 10), runif(n, 1, 10))
z <- runif(n, -5000, 10000)
AddBubbles(x, z = z, fg = "green", lwd = 2, title = "Title", loc = "topright",
           breaks=pretty(z, n = 8), add = FALSE)

Pal1 <- colorRampPalette(c("#F4A582", "#CA0020"))
Pal2 <- colorRampPalette(c("#92C5DE", "#0571B0"))
AddBubbles(x, z = z, bg.pos = Pal1, bg.neg = Pal2, add = FALSE)

AddBubbles(x, z = z, bg.pos = Pal1, bg.neg = Pal2, add = FALSE,
           make.intervals = TRUE)

AddBubbles(x, z = runif(n, 10, 10000), title = "Quantiles", bg.pos = topo.colors,
           quantile.breaks = TRUE, fg = NULL, add = FALSE)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\references{
Tanimura, S., Kuroiwa, C., and Mizota, T., 2006, Proportional Symbol Mapping in R: Journal of Statistical Software, v. 15, no. 5, 7 p.
}
\seealso{
\code{\link{symbols}}
}
\keyword{hplot}

