% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_sf.R
\name{clean_sf}
\alias{clean_sf}
\title{Clean a Simple Feature}
\usage{
clean_sf(x, cols = NULL, agr = NULL, crs = NULL, extent = NULL, type = NULL)
}
\arguments{
\item{x}{'sf' object.
Simple feature.}

\item{cols}{'character' vector.
Names indicating the columns to keep.
Vector names are optional and used to rename columns.}

\item{agr}{'character' vector.
Attribute geometry relationship,
specifies for each non-geometry attribute column how it relates to the geometry,
and can have one of following values: "constant", "aggregate", "identity".
Where "constant" is used for attributes that are constant throughout the geometry,
"aggregate" where the attribute is an aggregate value over the geometry,
"identity" when the attributes uniquely identifies the geometry of particular thing.
The default value assumes you don't know.
If named, vector names should correspond to the non-geometry list-column columns of \code{x}.}

\item{crs}{'crs' object.
Target coordinate reference system.}

\item{extent}{'bbox' object.
Spatial extent (aka bounding box) used to crop the simple feature.}

\item{type}{'character' vector.
For retured geometries of type "GEOMETRY" or "GEOMETRYCOLLECTION",
the returned object will consist only of elements of the specified type,
one of "POLYGON", "POINT", and "LINESTRING".}
}
\value{
Returns an object of class 'sf'.
}
\description{
Subset columns, transform coordinates,
and (or) crop the spatial extent of a simple feature.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
