% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_crs.R
\name{fm_sp_get_crs}
\alias{fm_sp_get_crs}
\title{Extract CRS information}
\usage{
fm_sp_get_crs(x)
}
\arguments{
\item{x}{A \code{sp::Spatial} object}
}
\value{
A \code{CRS} object, or NULL if no valid CRS identified
}
\description{
Wrapper for CRS(projargs) (PROJ4) and CRS(wkt) for
\code{sp::Spatial} objects.
}
\details{
This function is a convenience method to workaround PROJ4/PROJ6
differences, and the lack of a crs extraction method for Spatial objects.
}
\examples{
\dontrun{
if (interactive()) {
  s <- sp::SpatialPoints(matrix(1:6, 3, 2), proj4string = fm_CRS("sphere"))
  fm_sp_get_crs(s)
}
}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
