% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log}
\alias{bru_log}
\alias{bru_log.character}
\alias{bru_log.bru_log}
\alias{bru_log.iinla}
\alias{bru_log.bru}
\alias{print.bru_log}
\alias{as.character.bru_log}
\alias{[.bru_log}
\alias{c.bru_log}
\alias{length.bru_log}
\title{Access methods for \code{bru_log} objects}
\usage{
bru_log(x = NULL, verbosity = NULL)

\method{bru_log}{character}(x, verbosity = NULL)

\method{bru_log}{bru_log}(x, verbosity = NULL)

\method{bru_log}{iinla}(x, verbosity = NULL)

\method{bru_log}{bru}(x, verbosity = NULL)

\method{print}{bru_log}(x, ..., timestamp = TRUE, verbosity = FALSE)

\method{as.character}{bru_log}(x, ...)

\method{[}{bru_log}(x, i)

\method{c}{bru_log}(...)

\method{length}{bru_log}(x)
}
\arguments{
\item{x}{An object that is, contains, or can be converted to,
a \code{bru_log} object. If \code{NULL}, refers to the global \code{inlabru} log.}

\item{verbosity}{integer value for limiting the highest verbosity level being returned.}

\item{...}{further arguments passed to or from other methods.}

\item{timestamp}{If \code{TRUE}, include the timestamp of each message. Default \code{TRUE}.}

\item{i}{indices specifying elements to extract. If \code{character}, denotes
the sequence between bookmark \code{i} and the next bookmark (or the end of the
log if \code{i} is the last bookmark)}
}
\value{
\code{bru_log} A \code{bru_log} object, containing a
character vector of log messages, and potentially a vector of bookmarks.
}
\description{
Access method for \code{bru_log} objects.
Note: Up to version \verb{2.8.0}, \code{bru_log()} was a deprecated alias for \code{bru_log_message()}.
When running on \verb{2.8.0} or earlier, use \code{bru_log_get()} to access the global
log, and \code{cat(fit$bru_iinla$log, sep = "\\n")} to print a stored estimation object log.
After version \verb{2.8.0}, use \code{bru_log()} to access the global log, and
\code{bru_log(fit)} to access a stored estimation log.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(bru_log)}: Print a \code{bru_log} object with \code{cat(x, sep = "\\n")}.
If \code{verbosity} is \code{TRUE}, include the verbosity level of each message.

\item \code{as.character(bru_log)}: Convert \code{bru_log} object to a plain \code{character} vector

\item \code{[}: Extract a subset of a \code{bru_log} object

\item \code{c(bru_log)}: Concatenate several \code{bru_log} or \code{character} objects
into a \code{bru_log} object.

\item \code{length(bru_log)}: Obtain the number of log entries
into a \code{bru_log} object.

}}
\section{Functions}{
\itemize{
\item \code{bru_log()}: Extract stored log messages. If non-\code{NULL}, the \code{verbosity} argument
determines the maximum verbosity level of the messages to extract.

}}
\examples{
bru_log(verbosity = 2L)
print(bru_log(), timestamp = TRUE, verbosity = TRUE)

}
\seealso{
Other inlabru log methods: 
\code{\link{bru_log_bookmark}()},
\code{\link{bru_log_message}()},
\code{\link{bru_log_new}()},
\code{\link{bru_log_offset}()},
\code{\link{bru_log_reset}()}
}
\concept{inlabru log methods}
