% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cut_injd}
\alias{cut_injd}
\title{Cut the range of the follow-up}
\usage{
cut_injd(injd, date0, datef)
}
\arguments{
\item{injd}{Prepared data, an \code{injd} object.}

\item{date0}{Starting date of class \link[base:Dates]{Date} or
\link[base:numeric]{numeric}. If \code{numeric}, it should refer to a
year (e.g. \code{date} = 2018). Optional.}

\item{datef}{Ending date. Same class as \code{date0}. Optional.}
}
\value{
An \code{injd} object with a shorter follow-up period.
}
\description{
Given an \code{injd} object, cut the range of the time period such that the
limits of the observed dates, first and last observed dates, are \code{date0}
and \code{datef}, respectively. It is possible to specify just one date, i.e.
the two dates of the range do not necessarily have to be entered. See Note
section.
}
\note{
Be aware that by modifying the follow-up period of the cohort, the
study design is being altered. This function should not be used, unless
there is no strong argument supporting it. And in that case, it should be
used with caution.
}
\examples{
# Prepare data
\donttest{
df_injuries  <- prepare_inj(df_injuries0   = raw_df_injuries,
                           player         = "player_name",
                           date_injured   = "from",
                           date_recovered = "until")

df_exposures <- prepare_exp(df_exposures0 = raw_df_exposures,
                            player        = "player_name",
                            date          = "year",
                            time_expo     = "minutes_played")

injd <- prepare_all(data_exposures = df_exposures,
                    data_injuries  = df_injuries,
                    exp_unit = "matches_minutes")
}

\donttest{
cut_injd(injd, date0 = 2018)
}
}
