% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clusterrank}
\alias{clusterrank}
\alias{CR}
\title{ClusterRank (CR)}
\usage{
clusterrank(graph, vids = V(graph), directed = TRUE, loops = TRUE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument is ignored for undirected graphs.}

\item{loops}{Logical; whether the loop edges are also counted.}
}
\value{
A numeric vector contaning the ClusterRank centrality scores for the selected vertices.
}
\description{
This function calculates the ClusterRank of input vertices and
works with both directed and undirected networks.
This function and all of its descriptions have been obtained from the centiserve package.
For a complete description if the function and its arguments try this:
?centiserve::clusterrank
}
\examples{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
cr <- clusterrank(graph = My_graph, vids = GraphVertices, directed = FALSE, loops = TRUE)
}
\seealso{
\code{\link[centiserve]{clusterrank}} for a complete description on this function

Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{collective.influence}()},
\code{\link{degree}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()}
}
\concept{centrality functions}
\keyword{clusterrank}
