% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-os-var-test.R
\name{infer_os_var_test}
\alias{infer_os_var_test}
\alias{os_vartest}
\title{One Sample Variance Comparison Test}
\usage{
infer_os_var_test(data, x, sd, confint = 0.95, alternative = c("both",
  "less", "greater", "all"), ...)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{numeric; column in \code{data}}

\item{sd}{hypothesised standard deviation}

\item{confint}{confidence level}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{infer_os_var_test} returns an object of class \code{"infer_os_var_test"}.
An object of class \code{"infer_os_var_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{sd}{hypothesised standard deviation of \code{x}}
\item{sigma}{observed standard deviation}
\item{se}{estimated standard error}
\item{chi}{chi-square statistic}
\item{df}{degrees of freedom}
\item{p_lower}{lower one-sided p-value}
\item{p_upper}{upper one-sided p-value}
\item{p_two}{two-sided p-value}
\item{xbar}{mean of \code{x}}
\item{c_lwr}{lower confidence limit of standard deviation}
\item{c_upr}{upper confidence limit of standard deviation}
\item{var_name}{name of \code{x}}
\item{conf}{confidence level}
\item{type}{alternative hypothesis}
}
\description{
\code{infer_os_var_test} performs tests on the equality of standard
deviations (variances).It tests that the standard deviation of a sample is
equal to a hypothesized value.
}
\section{Deprecated Function}{

\code{os_vartest()} has been deprecated. Instead use \code{infer_os_var_test()}.
}

\examples{
# lower tail
infer_os_var_test(mtcars, mpg, 5, alternative = 'less')

# upper tail
infer_os_var_test(mtcars, mpg, 5, alternative = 'greater')

# both tails
infer_os_var_test(mtcars, mpg, 5, alternative = 'both')

# all tails
infer_os_var_test(mtcars, mpg, 5, alternative = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{var.test}}
}
