% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-levene-test.R
\name{infer_levene_test}
\alias{infer_levene_test}
\alias{infer_levene_test.default}
\alias{levene_test}
\alias{infer_levene_test.lm}
\alias{infer_levene_test.formula}
\title{Levene's test for equality of variances}
\usage{
infer_levene_test(variable, ...)

\method{infer_levene_test}{default}(variable, ..., group_var = NA,
  trim.mean = 0.1)

\method{infer_levene_test}{lm}(variable, ...)

\method{infer_levene_test}{formula}(variable, data, ...)
}
\arguments{
\item{variable}{a numeric vector or formula or object of class \code{lm}}

\item{...}{numeric vectors}

\item{group_var}{a grouping variable}

\item{trim.mean}{trimmed mean}

\item{data}{a data frame}
}
\value{
\code{infer_levene_test} returns an object of class \code{"infer_levene_test"}.
An object of class \code{"infer_levene_test"} is a list containing the
following components:

\item{bf}{Brown and Forsythe f statistic}
\item{p_bf}{p-value for Brown and Forsythe f statistic}
\item{lev}{Levene's f statistic}
\item{p_lev}{p-value for Levene's f statistic}
\item{bft}{Brown and Forsythe f statistic using trimmed mean}
\item{p_bft}{p-value for Brown and Forsythe f statistic using trimmed mean}
\item{avgs}{mean for each level of the grouping variable}
\item{sds}{standard deviations for each level of the grouping variable}
\item{avg}{combined mean}
\item{sd}{combined standard deviation}
\item{n}{number of observations}
\item{n_df}{numerator degrees of freedom}
\item{d_df}{denominator degrees of freedom}
\item{levs}{levels of the grouping variable}
\item{lens}{number of observations for each level of the grouping variable}
\item{type}{alternative hypothesis}
}
\description{
\code{infer_levene_test} reports Levene's robust test statistic
for the equality of variances and the
two statistics proposed by Brown and Forsythe that replace the mean in
Levene's formula with alternative location estimators. The first alternative
replaces the mean with the median. The second alternative replaces
the mean with the 10% trimmed mean.
}
\section{Deprecated Function}{

\code{levene_test()} has been deprecated. Instead use \code{infer_levene_test()}.
}

\examples{
# using grouping variable
infer_levene_test(hsb$read, group_var = hsb$race)

# using two variables
infer_levene_test(hsb$read, hsb$write, hsb$socst)

# using model
m <- lm(read ~ female, data = hsb)
infer_levene_test(m)

# using formula
infer_levene_test(as.formula(paste0('read ~ schtyp')), hsb)

}
\references{
{Bland, M. 2000. An Introduction to Medical Statistics. 3rd ed. Oxford: Oxford University Press.}

{Brown, M. B., and A. B. Forsythe. 1974. Robust tests for the equality of variances. Journal of the American Statistical
Association 69: 364–367.}

{Carroll, R. J., and H. Schneider. 1985. A note on Levene’s tests for equality of variances. Statistics and Probability
Letters 3: 191–194.}
}
